<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?><?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Tahoma', 'Arial', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            direction: rtl;
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .navbar .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            text-decoration: none;
        }
        
        .navbar-brand i {
            margin-left: 8px;
        }
        
        .navbar-menu {
            display: flex;
            gap: 25px;
            align-items: center;
            list-style: none;
        }
        
        .navbar-menu a {
            color: #333;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .navbar-menu a:hover {
            color: #667eea;
        }
        
        .navbar-menu .btn {
            background: #667eea;
            color: white;
            padding: 8px 20px;
            border-radius: 6px;
            text-decoration: none;
        }
        
        .navbar-menu .btn:hover {
            background: #5568d3;
            color: white;
        }
        
        .navbar-menu .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
            background: #f0f0f0;
            padding: 8px 15px;
            border-radius: 6px;
        }
        
        .navbar-menu .user-info i {
            color: #667eea;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        
        @media (max-width: 768px) {
            .navbar-menu {
                flex-direction: column;
                gap: 10px;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <a href="/" class="navbar-brand">
                <i class="fas fa-sim-card"></i>
                <?php echo SITE_NAME; ?>
            </a>
            <ul class="navbar-menu">
                <li><a href="/"><i class="fas fa-home"></i> خانه</a></li>
                <?php if (isLoggedIn()): ?>
                    <?php if (isAdmin()): ?>
                        <li><a href="/admin/"><i class="fas fa-cog"></i> پنل مدیریت</a></li>
                    <?php endif; ?>
                    <li><a href="/dashboard.php"><i class="fas fa-shopping-bag"></i> سفارشات من</a></li>
                    <li class="user-info">
                        <i class="fas fa-user"></i>
                        <span><?php echo htmlspecialchars($_SESSION['mobile']); ?></span>
                    </li>
                    <li><a href="/logout.php"><i class="fas fa-sign-out-alt"></i> خروج</a></li>
                <?php else: ?>
                    <li><a href="/login.php" class="btn">ورود / ثبت نام</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </nav>

